# Separate, dedicated plan for inventory role.
terraform {
  backend "s3" {
    bucket  = "twitch-grafana-dev"
    key     = "tfstate/systems/systems-terraform/development/grafana-dev/inventory/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-grafana-dev"
  }
}

provider "aws" {
  profile = "twitch-grafana-dev"
  alias   = "twitch-grafana-dev"
  region  = "us-west-2"
}

# Give inventory account access to ours.
module "twitch-inventory" {
  providers = {
    aws = aws.twitch-grafana-dev
  }
  source  = "git::git+ssh://git@git.xarth.tv/terraform-modules/twitch-inventory.git?ref=v2.0.1"
}
