# This plan makes a small jumpbox to get into the VPC using SSM. #
##################################################################

terraform {
  backend "s3" {
    bucket  = "twitch-grafana-dev"
    key     = "tfstate/systems/systems-terraform/development/grafana-dev/jumpbox/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-grafana-dev"
  }
}

provider "aws" {
  profile = "twitch-grafana-dev"
  alias   = "twitch-grafana-dev"
  region  = "us-west-2"
}

data "aws_ami" "instance_store_ami" {
  most_recent = true
  owners      = ["099720109477"]
  provider    = aws.twitch-grafana-dev

  filter {
    name   = "name"
    values = ["ubuntu/images/hvm-ssd/ubuntu-bionic-18.04-amd64-server-*"]
  }

  filter {
    name   = "virtualization-type"
    values = ["hvm"]
  }
}

module "instances" {
  providers = {
    aws = aws.twitch-grafana-dev
  }

  source                 = "git::git+ssh://git@git.xarth.tv/terraform-modules/aws-instance.git?ref=v3.0"
  r53_zone_id            = "Z3UD4SDI868JL2"
  environment            = "development"
  vpc_security_group_ids = ["sg-0639ad429806af3af"]
  subnet_ids             = ["subnet-05036069ef815629b", "subnet-0832764d2858761d9"]
  service                = "jumpbox"
  role                   = "jumpbox"
  ami                    = data.aws_ami.instance_store_ami.id
  instance_type          = "t2.small"
  owner                  = "systems"
  instance_count         = "1"
}
