# ./account_template -env "" -ver dn2_no_dns_no_peering twitch-grafana-dev 10.10.0.0/22
# Autogenerated by https://code.justin.tv/terraform-modules/account_template/vpccreator
# Account: twitch-grafana-dev (us-west-2/), CIDR: 10.10.0.0/20, Module: git-aws.internal.justin.tv/terraform-modules/account_template.git?ref=dn2_no_dns_no_peering
#
terraform {
  backend "s3" {
    # This bucket must be created manually before this plan will run!
    bucket  = "twitch-grafana-dev"
    key     = "tfstate/systems/systems-terraform/development/grafana-dev/vpc/terraform.tfstate"
    region  = "us-west-2" # this is where the bucket that contains the state file lives.
    profile = "twitch-grafana-dev"
  }
}

provider "aws" {
  profile = "twitch-grafana-dev"
  alias   = "twitch-grafana-dev-us-west-2"
  region  = "us-west-2"
}

module "us-west-2" {
  providers = {
    aws = aws.twitch-grafana-dev-us-west-2
  }

  source             = "git::git+ssh://git@git.xarth.tv/terraform-modules/account_template.git?ref=v2.1.12"
  vpc_cidr           = "10.10.0.0/22"
  owner              = "twitch-grafana-dev@amazon.com"
  region             = "us-west-2"
  environment        = ""
  credential_profile = "twitch-grafana-dev"
  account_name       = "twitch-grafana-dev"
}

output "us_west_2_private_subnets" {
  value = module.us-west-2.private_subnets
}

output "us_west_2_public_subnets" {
  value = module.us-west-2.public_subnets
}

output "us_west_2_twitch_subnets_sg_id" {
  value = module.us-west-2.twitch_subnets_sg_id
}

output "us_west_2_vpc_id" {
  value = module.us-west-2.vpc_id
}
