variable "metric_heartbeat" {
  default = "GrafanaserverHealthChecker"
}

variable "metric_namespace" {
  default = "GrafanaserverMetrics"
}

resource "aws_cloudwatch_log_metric_filter" "heartbeat_metric" {
  name           = "grafana-server-${var.environment}-lb-healthchecker"
  pattern        = "\"Request Completed\""
  log_group_name = "/fargate/service/grafana-server-${var.environment}"

  metric_transformation {
    name          = var.metric_heartbeat
    namespace     = var.metric_namespace
    value         = "1"
    default_value = "0"
  }

  depends_on = [aws_cloudwatch_log_group.logs]
}

resource "aws_cloudwatch_metric_alarm" "grafana_server" {
  alarm_name                = "Grafana Server ${var.environment} Not Running"
  comparison_operator       = "LessThanThreshold"
  evaluation_periods        = "3"
  metric_name               = var.metric_heartbeat
  namespace                 = var.metric_namespace
  period                    = "60"
  statistic                 = "Sum"
  threshold                 = "1"
  alarm_description         = "Grafana server ALB health check activity has not been seen in the past 10 minutes"
  insufficient_data_actions = [aws_sns_topic.pagerduty.arn]
  alarm_actions             = [aws_sns_topic.pagerduty.arn]
}

# This topic is also used by the aurora-snapshot-tool CloudFormation as an alarm target.
resource "aws_sns_topic" "pagerduty" {
  name = "metrics-grafana-server-${var.environment}-pagerduty"
}
