### lb for renderer cluster

resource "aws_alb" "grafana_image_renderer" {
  name            = "ecs-grafana-image-renderer"
  internal        = true
  security_groups = var.vpc_security_group_ids
  subnets         = var.subnet_ids
}

resource "aws_alb_listener" "grafana_image_renderer" {
  load_balancer_arn = aws_alb.grafana_image_renderer.arn
  port              = "8081"
  protocol          = "HTTP"

  default_action {
    target_group_arn = aws_alb_target_group.grafana_image_renderer.id
    type             = "forward"
  }
}

resource "aws_alb_target_group" "grafana_image_renderer" {
  name        = "grafana-image-renderer"
  port        = 8081
  protocol    = "HTTP"
  vpc_id      = var.vpc_id
  target_type = "ip"

  health_check {
    healthy_threshold   = 5
    unhealthy_threshold = 3
    timeout             = 5
    interval            = 10
    path                = "/"
    matcher             = "200"
  }
}
