# Pagerduty Token comes from Pagerduty:
# https://twitchoncall.pagerduty.com/api_keys
# It can be kept in a sourceable bash environment file or run at the command
# line before running Terraform:
#   export TF_VAR_pagerduty_token=$PAGERDUTY_KEY

provider "pagerduty" {
  token = var.pagerduty_token
}

variable "pagerduty_token" {}

data "pagerduty_escalation_policy" "systems" {
  name = "Systems Engineering"
}

data "pagerduty_vendor" "cloudwatch" {
  name = "Cloudwatch"
}

resource "pagerduty_service" "grafana_server" {
  name                    = "grafana-server-${var.environment}"
  auto_resolve_timeout    = "null"
  acknowledgement_timeout = "null"
  escalation_policy       = data.pagerduty_escalation_policy.systems.id
  alert_creation          = "create_incidents"
  description             = "https://wiki.twitch.com/display/SYS/Grafana+Runbooks"

  incident_urgency_rule {
    type    = "constant"
    urgency = var.environment == "production" ? "high" : "low"
  }
}

resource "pagerduty_service_integration" "cloudwatch" {
  name    = data.pagerduty_vendor.cloudwatch.name
  service = pagerduty_service.grafana_server.id
  vendor  = data.pagerduty_vendor.cloudwatch.id
}

resource "aws_sns_topic_subscription" "pagerduty" {
  topic_arn              = aws_sns_topic.pagerduty.arn
  protocol               = "https"
  endpoint               = "https://events.pagerduty.com/integration/${pagerduty_service_integration.cloudwatch.integration_key}/enqueue"
  endpoint_auto_confirms = true
}
