# Setup the needed access for our deploy pipeline to make changes in our account.

resource "aws_iam_role" "grafana_deploy" {
  name = "grafana-${var.environment}-deploy"
  path = "/"

  assume_role_policy = data.aws_iam_policy_document.grafana_deploy.json
}

data "aws_iam_policy_document" "grafana_deploy" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    principals  {
        type        = "AWS"
        identifiers = ["arn:aws:iam::994136867826:root"]
    }
  }
}

data "aws_iam_policy_document" "grafana_deploy_policies" {
  statement {
    actions = [
      "ecs:*",
      "ecr:*",
    ]

    resources = [
      "*",
    ]
  }

  statement {
    actions = [
      "iam:PassRole",
    ]

    resources = [
      aws_iam_role.ecsTaskExecutionRole.arn,
    ]
  }
}

resource "aws_iam_policy" "grafana_deploy_policy" {
  name   = "grafana-deploy-policy"
  policy = data.aws_iam_policy_document.grafana_deploy_policies.json
}

resource "aws_iam_role_policy_attachment" "grafana_deploy_policy" {
  role       = aws_iam_role.grafana_deploy.name
  policy_arn = aws_iam_policy.grafana_deploy_policy.arn
}

# output
output "deploy_arn" {
  value = aws_iam_role.grafana_deploy.arn
}
