# This plan makes a small jumpbox to get into the VPC using SSM. #
##################################################################

terraform {
  backend "s3" {
    bucket  = "twitch-grafana-prod"
    key     = "tfstate/systems/systems-terraform/production/grafana-prod/instance/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-grafana-prod"
  }
}

provider "aws" {
  profile = "twitch-grafana-prod"
  alias   = "twitch-grafana-prod"
  region  = "us-west-2"
}

data "aws_ami" "instance_store_ami" {
  most_recent = true
  owners      = ["099720109477"]
  provider    = aws.twitch-grafana-prod

  filter {
    name   = "name"
    values = ["ubuntu/images/hvm-ssd/ubuntu-bionic-18.04-amd64-server-*"]
  }

  filter {
    name   = "virtualization-type"
    values = ["hvm"]
  }
}

module "instances" {
  providers = {
    aws = aws.twitch-grafana-prod
  }

  source                 = "git::git+ssh://git@git.xarth.tv/terraform-modules/aws-instance.git?ref=v3.0"
  r53_zone_id            = "Z1SEQQN1THN3CT"
  environment            = "production"
  vpc_security_group_ids = ["sg-eb9920a5"]
  subnet_ids             = ["subnet-bb1309e1", "subnet-23bbb35a", "subnet-6cd7e227"]
  service                = "jumpbox"
  role                   = "jumpbox"
  ami                    = data.aws_ami.instance_store_ami.id
  instance_type          = "t2.small"
  owner                  = "systems"
  instance_count         = "1"
}
