# Separate, dedicated plan for inventory (capacity management) role.
terraform {
  backend "s3" {
    bucket  = "twitch-grafana-prod"
    key     = "tfstate/systems/systems-terraform/production/grafana-prod/inventory/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-grafana-prod"
  }
}

provider "aws" {
  profile = "twitch-grafana-prod"
  alias   = "twitch-grafana-prod"
  region  = "us-west-2"
}

# Give inventory account access to ours.
module "twitch-inventory" {
  providers = {
    aws = aws.twitch-grafana-prod
  }
  source  = "git::git+ssh://git@git.xarth.tv/terraform-modules/twitch-inventory.git?ref=v2.0.1"
}
