# Autogenerated by https://code.justin.tv/terraform-modules/account_template/vpccreator
#
# Using terraform 0.11.14, run this like so:
# terraform init ; terraform plan
#
# Credentials must be available for account 'twitch-grafana-prod'
#

provider "aws" {
  profile = "twitch-grafana-prod"
  alias   = "twitch-grafana-prod-us-east-2"
  region  = "us-east-2"
}

module "us-east-2" {
  enable_vgw = "false" # set true if using direct-connects
  name       = "twitch-grafana-prod"
  owner      = "twitch-grafana-prod@amazon.com"
  source     = "git::git+ssh://git@git.xarth.tv/terraform-modules/account_template.git?ref=v4.0.0"
  vpc_cidr   = "10.128.0.0/16"
  tags       = map("Environment", "production")

  providers = {
    aws = aws.twitch-grafana-prod-us-east-2
  }
}

output "us_east_2_private_subnets" {
  value = module.us-east-2.private_subnets
}

output "us_east_2_public_subnets" {
  value = module.us-east-2.public_subnets
}

output "us_east_2_twitch_subnets_sg_id" {
  value = module.us-east-2.twitch_subnets_sg_id
}

output "us_east_2_vpc_id" {
  value = module.us-east-2.vpc_id
}

output "us_east_2_azset" {
  value = module.us-east-2.azset
}

# Prod Peering
resource "aws_vpc_peering_connection" "us_east_2_original_vpc_peer" {
  provider      = aws.twitch-grafana-prod-us-east-2
  peer_owner_id = data.aws_caller_identity.us_east_2_current.account_id
  vpc_id        = module.us-east-2.vpc_id
  peer_vpc_id   = var.production_vpc
  peer_region   = "us-west-2"
}

resource "aws_route" "us_east_2_in" {
  provider                  = aws.twitch-grafana-prod-us-east-2
  count                     = length(module.us-east-2.route_table_ids)
  route_table_id            = module.us-east-2.route_table_ids[count.index]
  destination_cidr_block    = var.production_cidr
  vpc_peering_connection_id = aws_vpc_peering_connection.us_east_2_original_vpc_peer.id
}

resource "aws_route" "us_east_2_out" {
  provider                  = aws.twitch-grafana-prod-us-west-2
  count                     = length(var.production_rts)
  route_table_id            = var.production_rts[count.index]
  destination_cidr_block    = "10.128.0.0/16"
  vpc_peering_connection_id = aws_vpc_peering_connection.us_east_2_original_vpc_peer.id
}

resource "aws_vpc_peering_connection_accepter" "us_east_2_peer_accept" {
  provider                  = aws.twitch-grafana-prod-us-west-2
  vpc_peering_connection_id = aws_vpc_peering_connection.us_east_2_original_vpc_peer.id
  auto_accept               = true
}

# Dev Peering
resource "aws_vpc_peering_connection" "us_east_2_dev_vpc_peer" {
  provider      = aws.twitch-grafana-prod-us-east-2
  peer_owner_id = data.aws_caller_identity.us_west_2_dev.account_id
  vpc_id        = module.us-east-2.vpc_id
  peer_vpc_id   = var.development_vpc
  peer_region   = "us-west-2"
}

resource "aws_route" "us_east_2_in_dev" {
  provider                  = aws.twitch-grafana-prod-us-east-2
  count                     = length(module.us-east-2.route_table_ids)
  route_table_id            = module.us-east-2.route_table_ids[count.index]
  destination_cidr_block    = var.development_cidr
  vpc_peering_connection_id = aws_vpc_peering_connection.us_east_2_dev_vpc_peer.id
}

resource "aws_route" "us_east_2_out_dev" {
  provider                  = aws.twitch-grafana-dev-us-west-2
  count                     = length(var.development_rts)
  route_table_id            = var.development_rts[count.index]
  destination_cidr_block    = "10.128.0.0/16"
  vpc_peering_connection_id = aws_vpc_peering_connection.us_east_2_dev_vpc_peer.id
}

resource "aws_vpc_peering_connection_accepter" "us_east_2_peer_accept_dev" {
  provider                  = aws.twitch-grafana-dev-us-west-2
  vpc_peering_connection_id = aws_vpc_peering_connection.us_east_2_dev_vpc_peer.id
  auto_accept               = true
}
