variable "production_vpc" {
  type    = string
  default = "vpc-4fcf7137"
}

# used to add route table entries the other way.
variable "production_cidr" {
  type    = string
  default = "172.31.0.0/16"
}

# used to add route table entries.
variable "production_rts" {
  type    = list(string)
  default = ["rtb-0622e50bf4ba18fe6", "rtb-0d59c7d69771769bc", "rtb-0292dbd812633e6c8"]
}

variable "development_vpc" {
  type    = string
  default = "vpc-08ee0aca12c607163"
}

# used to add route table entries the other way.
variable "development_cidr" {
  type    = string
  default = "10.10.0.0/22"
}

# used to add route table entries.
variable "development_rts" {
  type    = list(string)
  default = ["rtb-0bad91df118143481", "rtb-0d36bfd6172222569", "rtb-0b7857cd8b2a164f4"]
}

data "aws_caller_identity" "us_east_2_current" {
  provider = aws.twitch-grafana-prod-us-east-2
}

data "aws_caller_identity" "us_west_2_current" {
  provider = aws.twitch-grafana-prod-us-west-2
}

data "aws_caller_identity" "us_west_2_dev" {
  provider = aws.twitch-grafana-dev-us-west-2
}

terraform {
  backend "s3" {
    # This bucket must be created manually before this plan will run!
    # You may also change this bucket name to one that already exists.
    bucket  = "twitch-grafana-prod"
    key     = "tfstate/systems/systems-terraform/production/grafana-prod/vpc/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-grafana-prod"
  }
}

