package envoy

import (
	"net/http"
	"sync/atomic"
)

var (
	singleton   *Envoy
	initialized uint32 = 0
)

// Call Init exactly once to initialize the default envoy client.
// Calling Init causes envoy to begin listening for HTTP requests on
// the chosen interface and port (if specified) and to begin submitting
// state transitions to passively to Nagios (if specified).
func Init(config *Config) {
	swapped := atomic.CompareAndSwapUint32(&initialized, 0, 1)
	if !swapped {
		panic("envoy.Init can only be called once")
	}
	singleton.confInit(config)
}

// HealthHandler is the http handler for the default envoy client
func HealthHandler(w http.ResponseWriter, r *http.Request) { singleton.HealthHandler(w, r) }

// NewState creates a State object for the default envoy client
func NewState(name string, description string, startCon Condition) *State {
	return singleton.NewState(name, description, startCon)
}

// Update atomically changes the condition for one or more states for the default envoy client
func Update(updates StateUpdates) { singleton.Update(updates) }

func init() {
	singleton = NewEnvoy(nil)
}
