package config

import "flag"

var (
	ListenAddress       = flag.String("listen-address", ":1234", "service API requests on this endpoint")
	OverusedIPsHostName = flag.String("overused-ips-hostname", "localhost", "Set the hostname for the http request for overused ips")
	OverusedIPsPort     = flag.String("overused-ips-port", "4549", "Set the port for the http request for overused ips")
	AsnPath             = flag.String("asn-path", "/usr/share/GeoIP/GeoLiteASNum.dat", "location of GeoIP database file with ASNums")
	RepDBPath           = flag.String("rep-db-path", "/var/lib/iprep-scores-import/vba_score/vba_score.db", "location of SQLite reputation database file")
	StatsdHost          = flag.String("statsd-host", "statsd.internal.justin.tv", "statsd hostname")
	StatsdPort          = flag.String("statsd-port", "8125", "statsd port")
	StatsdAppName       = flag.String("stats-app-name", "shodan", "app name for statsd")
)
