job {
	name "abuse-shodan"
	using 'TEMPLATE-autobuild'

	wrappers {
		credentialsBinding {
			string 'AWS_ACCESS_KEY', 'video-aws-access-key'
			string 'AWS_SECRET_KEY', 'video-aws-secret-key'
		}
	}

	scm {
		git {
			remote {
				github 'abuse/shodan', 'ssh', 'git-aws.internal.justin.tv'
				credentials 'git-aws-read-key'
			}
			clean true
		}
	}

	steps {
		shell 'rm -rf .manta/'
		shell 'manta -v -proxy'
		createBeanstalkArtifactFromDirectory 'shodan', "\$GIT_COMMIT", 'elasticbeanstalk-us-west-2-848744099708', '.manta'
	}
}

job {
	name "abuse-shodan-deploy"
	using 'TEMPLATE-deploy'

	wrappers {
		credentialsBinding {
			string 'AWS_ACCESS_KEY', 'video-aws-access-key'
			string 'AWS_SECRET_KEY', 'video-aws-secret-key'
		}
	}

	steps {
		deployElasticBeanstalkArtifact 'shodan', "\$ENVIRONMENT", "\$GIT_COMMIT"
	}
}
