from __future__ import print_function

import json
import boto3

def lambda_handler(event, context):
    acct = event['account']
    trailname = event['detail']['requestParameters']['name']
    region = event['region']
    evTime = event['detail']['eventTime']
    prinId = event['detail']['userIdentity']['principalId']
    status_note = ""
    response = ""

    client = boto3.client(service_name='cloudtrail', region_name=region)

    try:
        response = client.start_logging(Name=trailname)
    except:
        response = "Error"
        status_note = "Error restarting Cloudtrail."
    else:
        if response['ResponseMetadata']['HTTPStatusCode'] == 200:
            status_note = "Cloudtrail restarted successfully."
        else:
            status_note = "Error restarting Cloudtrail."

    print(response)

    sns = boto3.client(service_name='sns', region_name='us-west-2')
    topicArn = 'arn:aws:sns:us-west-2:508423404353:twitch-sirt'

    msg = 'Alert - CloudTrail Disabled. Time: {} Account: {} Region: {} User: {} Trail: {} Note: {}'.format(evTime, acct, region, prinId, trailname, status_note)
    snsmsg = 'Alert - CloudTrail Disabled.\nTime: {}\nAccount: {}\nRegion: {}\nUser: {}\nTrail: {}\nNote: {}\n\nDetails:\n{}'.format(evTime, acct, region, prinId, trailname, status_note, event)

    response = sns.publish(
        TargetArn = topicArn,
        Message = snsmsg,
        MessageStructure = 'raw'
    )
    print(response)
    print(event)
    print(msg)

    return
