package logparse

import (
	"encoding/json"
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestDuration(t *testing.T) {
	t.Run("marshal", func(t *testing.T) {
		og := Duration(time.Millisecond)

		t.Run("as json", func(t *testing.T) {
			marshalled, err := json.Marshal(og)
			require.NoError(t, err)

			var unmarshalled Duration
			require.NoError(t, json.Unmarshal(marshalled, &unmarshalled))

			assert.Equal(t, og, unmarshalled)

		})
	})
}
