package logparse

import (
	"encoding/json"
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestTime(t *testing.T) {
	t.Run("should strip time zone when marshaled", func(t *testing.T) {
		og := Time(time.Now().
			Truncate(time.Second).
			In(time.FixedZone("Beijing Time", int((8 * time.Hour).Seconds()))))
		ogUTC := Time(time.Time(og).UTC())

		t.Run("as json", func(t *testing.T) {
			marshalled, err := json.Marshal(og)
			require.NoError(t, err)

			var unmarshalled Time
			require.NoError(t, json.Unmarshal(marshalled, &unmarshalled))

			assert.Equal(t, ogUTC, unmarshalled)
		})
	})
}
