package main

import (
	"log"
	"os"

	"github.com/aws/aws-lambda-go/lambda"
)

func getEnvironment() string {
	environment, ok := os.LookupEnv("ENVIRONMENT")
	if !ok {
		log.Fatal("$ENVIRONMENT is a required environment variable")
	}
	return environment
}

func main() {
	h := &handler{
		Environment: getEnvironment(),
	}
	lambda.Start(h.Handle)
}
