data "aws_cloudwatch_log_group" "admin-panel" {
  name = "admin-panel-${var.env}"
}

resource "aws_lambda_permission" "extract_cloudwatch_metrics" {
  statement_id  = "AllowExecutionFromCloudWatch"
  action        = "lambda:InvokeFunction"
  function_name = "${aws_lambda_function.extract_cloudwatch_metrics.function_name}"
  principal     = "logs.us-west-2.amazonaws.com"
  source_arn    = "${data.aws_cloudwatch_log_group.admin-panel.arn}"
}

resource "aws_cloudwatch_log_subscription_filter" "extract_cloudwatch_metrics" {
  name            = "${local.prefix}-logs-to-metrics"
  log_group_name  = "${data.aws_cloudwatch_log_group.admin-panel.name}"
  filter_pattern  = "_type"
  destination_arn = "${aws_lambda_function.extract_cloudwatch_metrics.arn}"
}
