resource "aws_lambda_function" "extract_cloudwatch_metrics" {
  function_name = "${local.prefix}-extract_cloudwatch_metrics"
  description   = "Extract cloudwatch metrics from a cloudwatch stream"
  handler       = "main"
  role          = "${aws_iam_role.extract_cloudwatch_metrics.arn}"
  filename      = "${module.dummy-go-lambda-zip.filename}"
  runtime       = "go1.x"
  timeout       = "30"

  environment {
    variables = {
      ENVIRONMENT = "${var.env}"
    }
  }

  lifecycle {
    ignore_changes = [
      "filename",
    ]
  }
}

module "extract_cloudwatch_metrics-lambda-deploy-role" {
  source         = "../lambda-deploy-role"
  aws_account_id = "${var.aws_account_number}"
  lambda_arn     = "${aws_lambda_function.extract_cloudwatch_metrics.arn}"
  lambda_name    = "${aws_lambda_function.extract_cloudwatch_metrics.function_name}"
  role_path      = "${local.deploy_role_path}"
  allowed_arns   = ["${var.allowed_deploy_arns}"]
}

resource "aws_iam_role" "extract_cloudwatch_metrics" {
  name               = "${local.prefix}-extract_cloudwatch_metrics"
  path               = "${local.role_path}"
  assume_role_policy = "${data.aws_iam_policy_document.lambda-arp.json}"
}

resource "aws_iam_role_policy" "extract_cloudwatch_metrics" {
  role   = "${aws_iam_role.extract_cloudwatch_metrics.id}"
  policy = "${data.aws_iam_policy_document.extract_cloudwatch_metrics-rp.json}"
}

data "aws_iam_policy_document" "extract_cloudwatch_metrics-rp" {
  statement {
    actions = [
      "cloudwatch:PutMetricData",
    ]

    resources = [
      "*",
    ]
  }
}

resource "aws_iam_role_policy_attachment" "extract_cloudwatch_metrics-cw-logging" {
  role       = "${aws_iam_role.extract_cloudwatch_metrics.id}"
  policy_arn = "arn:aws:iam::aws:policy/CloudWatchLogsFullAccess"
}
