resource "aws_iam_role" "lambda-deploy" {
  name               = "${local.resource_name}"
  path               = "${var.role_path}"
  description        = "role to deploy ${var.lambda_name}"
  assume_role_policy = "${data.aws_iam_policy_document.lambda-deploy-arp.json}"
}

data "aws_iam_policy_document" "lambda-deploy-arp" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    effect = "Allow"

    principals {
      type        = "AWS"
      identifiers = ["${var.allowed_arns}"]
    }
  }
}

resource "aws_iam_role_policy" "lambda-deploy" {
  name   = "${local.resource_name}"
  role   = "${aws_iam_role.lambda-deploy.id}"
  policy = "${data.aws_iam_policy_document.lambda-deploy-rp.json}"
}

data "aws_iam_policy_document" "lambda-deploy-rp" {
  statement {
    actions = [
      "lambda:UpdateFunctionCode",
    ]

    effect = "Allow"

    resources = [
      "${var.lambda_arn}",
    ]
  }
}
