provider "aws" {
  version = "~> 1.4"
  region  = "us-west-2"

  allowed_account_ids = [
    "196915980276", // twitch-admin-panel-aws
  ]

  profile = "twitch-admin-panel-aws"
}

terraform {
  backend "s3" {
    bucket  = "twitch-admin-panel-aws"
    key     = "tfstate/foundation/admin-panel-lambdas/terraform/production"
    region  = "us-west-2"
    profile = "twitch-admin-panel-aws"
  }
}

module "admin-panel-lambdas" {
  source             = "../modules/admin-panel-lambdas"
  aws_account_number = "196915980276"
  env                = "production"

  allowed_deploy_arns = [
    "arn:aws:iam::516651178292:user/jenkins",
  ]
}
