provider "aws" {
  version = "~> 1.4"
  region  = "us-west-2"

  allowed_account_ids = [
    "219087926005", // twitch-admin-panel-dev
  ]

  profile = "twitch-admin-panel-dev"
}

terraform {
  backend "s3" {
    bucket  = "twitch-admin-panel-dev"
    key     = "tfstate/foundation/admin-panel-lambdas/terraform/staging"
    region  = "us-west-2"
    profile = "twitch-admin-panel-dev"
  }
}

module "admin-panel-lambdas" {
  source             = "../modules/admin-panel-lambdas"
  aws_account_number = "219087926005"
  env                = "staging"

  allowed_deploy_arns = [
    "arn:aws:iam::516651178292:user/jenkins",
  ]
}
