// This is a manifest file that'll be compiled into application.js, which will include all the files
// listed below.
//
// Any JavaScript/Coffee file within this directory, lib/assets/javascripts, vendor/assets/javascripts,
// or any plugin's vendor/assets/javascripts directory can be referenced here using a relative path.
//
// It's not advisable to add code directly here, but if you do, it'll appear at the bottom of the
// compiled file. JavaScript code in this file should be added after the last require_* statement.
//
// Read Sprockets README (https://github.com/rails/sprockets#sprockets-directives) for details
// about supported directives.
//
//= require jquery
//= require moment
//= require jquery_ujs
//= require twitter/bootstrap
//= require bootstrap
//= require cable
//= require chosen.jquery.min
//= require duo
//= require algolia/v3/algoliasearch.min
//= require twemoji
//
//= require_tree .

$(document).ready(function () {
  twemoji.parse(document.body, {
    folder: "svg",
    ext: ".svg",
  });

  // Listen for alert closures to remove the session notice cookie
  $(".alert").on("closed.bs.alert", function (e) {
    // check whether the closing alert contains our new home notice
    if ($(e.target).has("#new_home").length > 0) {
      // Cookies are "deleted" by creating a new cookie with the
      // same name and path, with an expiration date in the past.
      // note: the cookie path *must* be the same, or it's
      //       technically a "different" cookie
      var yesterday = new Date(new Date() - 86400000);
      document.cookie = "session_notice=; path=/; expires=" + yesterday;
    }
  });
});
