var SupportTools = {
  contentsElement: null,
  reasonsElement: null,
  detailedReasonsElement: null,

  init: function(suspensionGuides){
    SupportTools.contentsElement = document.getElementById('support_tools_user_job_content');
    SupportTools.reasonsElement = document.getElementById('support_tools_user_job_reason');
    SupportTools.detailedReasonsElement = document.getElementById('support_tools_user_job_detailed_reason');

    if (!suspensionGuides) {
      console.error("Suspension guide is not loaded!")
      return;
    }

    var contents = suspensionGuides['contents'];
    SupportTools.contentsElement.options.add(SupportTools.dummyOption("Select a content..."));
    for (var key in contents) {
      var content = contents[key];
      SupportTools.contentsElement.options.add(new Option(content['content_display'], content['content']));
    }

    // Populate default values
    SupportTools.updateReasonHandler(contents);

    SupportTools.contentsElement.onchange = function () {
      SupportTools.updateReasonHandler(contents);
      SupportTools.allowSubmit();
    }

    $('.required').bind('keyup', function() {
      SupportTools.allowSubmit();
    });
  },

  allowSubmit() {
    var allow = true;

    $('.required').each(function() {
      // Disallow submit if any non-hidden element has no value
      if(!$(this).parents('.hidden').length > 0 && $(this).val() == '') {
        allow = false;
      }
    });

    if (allow) {
      $('#submit').removeAttr('disabled');
    } else {
      $('#submit').attr('disabled', 'disabled');
    }
  },

  updateReasonHandler: function (contents) {
    if (!SupportTools.contentsElement || SupportTools.contentsElement.selectedOptions.length == 0) {
      return;
    }
    var selectedContent = SupportTools.contentsElement.selectedOptions[0].value

    // Clear existing reasons
    SupportTools.removeAllSelectElementOptions(SupportTools.reasonsElement);

    SupportTools.reasonsElement.options.add(SupportTools.dummyOption("Select a reason..."));
    
    if (contents[selectedContent]) {
      var reasons = contents[selectedContent].reasons;
      for (var key in reasons) {
        var reason = reasons[key];
        SupportTools.reasonsElement.options.add(new Option(reason['reason_display'], reason['reason']));
      }
      // Populate default values
      SupportTools.updateDetailedReasonHandler(reasons);
  
      SupportTools.reasonsElement.onchange = function () {
        SupportTools.updateDetailedReasonHandler(reasons);
        SupportTools.allowSubmit();
      }
    } else {
      SupportTools.detailedReasonsElement.options.add(SupportTools.dummyOption("Select a detailed reason..."));
    }
  },

updateDetailedReasonHandler: function (reasons) {
  if (!SupportTools.reasonsElement || SupportTools.reasonsElement.selectedOptions.length == 0) {
    return;
  }
  var selectedReason = SupportTools.reasonsElement.selectedOptions[0].value

  // Clear existing detailed reasons
  SupportTools.removeAllSelectElementOptions(SupportTools.detailedReasonsElement);

  SupportTools.detailedReasonsElement.options.add(SupportTools.dummyOption("Select a detailed reason..."));

  if (reasons[selectedReason]) {
    var detailedReasons = reasons[selectedReason].detailed_reasons;
    for (var key in detailedReasons) {
      var detailedReason = detailedReasons[key];
      var drOption = new Option(detailedReason['detailed_reason_display'], detailedReason['detailed_reason']);
      drOption.setAttribute('data-points', detailedReason.points || 1);
      SupportTools.detailedReasonsElement.options.add(drOption);
    }
    // handle default values
    SupportTools.updateDurationHandler();
    SupportTools.detailedReasonsElement.onchange = function () {
      SupportTools.updateDurationHandler();
      SupportTools.allowSubmit();
    }
  }
},

dummyOption: function(display) {
  return new Option(display, '');
},

updateDurationHandler: function () {
  if (!SupportTools.detailedReasonsElement || SupportTools.detailedReasonsElement.selectedOptions.length == 0) {
    return;
  }

  var selectedDetailedReason = SupportTools.detailedReasonsElement.selectedOptions[0]
  var selectedPoints = Number(selectedDetailedReason.getAttribute('data-points')).toFixed(0);

  // moderation has decided that 100 points is a permanent ban
  if (selectedPoints >= 100) {
    $("#support_tools_user_job_is_permanent").prop('checked', true).trigger('change');
  } else {
    $("#support_tools_user_job_is_permanent").prop('checked', false).trigger('change');
    var selectorForOption = "#support_tools_user_job_duration option[value=" + (selectedPoints || 1) + "]"
    $(selectorForOption).prop('selected', true);
  }
},

 removeAllSelectElementOptions: function(element) {
   while (element.options.length > 0) {
     element.options.remove(0);
   }
 }
}
