$(document).ready(function () {
  if (/auth|twofa/.test(location.pathname.split('/').filter(Boolean)[0])) {
    return
  }

  // Renabling after https://jira.xarth.tv/browse/SIRT-8526 as cleared
  var duration = 0;

  var heartbeat = setInterval(function () {
    $.post('/tracking/heartbeat', {
        "duration": duration,
        "is_active_tab": document.hasFocus(),
        "is_visible": !document.hidden,
        "location": location.pathname,
      })
      .fail(function (jqXHR) {
        if (jqXHR.status === 403) {
          clearInterval(heartbeat)
        }
      })
    duration += 5;
  }, 5000);
});
