class @UserEdit
  @confirm_prompt = (login) ->

    edit_save = $('#user_edit_button')

    edit_save.click (e) ->
      if !confirm('Are you sure you want to edit ' + login + '?')
        e.preventDefault()
        return false
      return true

  @activation_management_prompt = (login, flagged) ->

    deactivate = $('button[name="deactivate"]')
    reactivate = $('button[name="reactivate"]')

    deactivate.click (e) ->
      flagged = $('input[name="flagged_for_rename"]').prop('checked')

      addendum =
        (flagged && 
          "\n\nThis will also flag the account for a required username reset during its next login."
        ) || ""

      msg = "Are you sure you want to deactivate " + login + "?" + addendum

      if !confirm(msg)
        e.preventDefault()
        return false
      return true

    reactivate.click (e) ->
      addendum =
        (flagged &&
          "\n\nThis account is currently flagged for a required username reset during its next login.\
           \n\nReactiving this account manually will also remove the required username reset flag."
        ) || ""

      msg = "Are you sure you want to reactivate " + login + "?" + addendum

      if !confirm(msg)
        e.preventDefault()
        return false
      return true


  @birthday_init = (birthday) ->
    $('#birthday').datepicker({ defaultDate: birthday})
