module Ads
  class AutoAdsController < ApplicationController
    before_action :check_auth
    before_action :set_login, only: [:edit, :update]

    def edit
    end

    def update
      @auto_ad.attributes = update_params
      @auto_ad.save
      redirect_to twitch_user_path(params[:id])
    end

    def update_params
      aa_params = params["ads_auto_ad"]
      {
        channel_id: params[:id],
        ccp_start_date: aa_params[:ccp_start_date],
        ccp_end_date: aa_params[:ccp_end_date],
        density_target_minutes_per_hour: aa_params[:density_target_minutes_per_hour],
        surge_start_date: aa_params[:surge_start_date],
        surge_end_date: aa_params[:surge_end_date],
        surge_density_target_minutes_per_hour: aa_params[:surge_density_target_minutes_per_hour],
      }
    end

    private

    def check_auth
      @auto_ad = AutoAd.find(params[:id])
      authorize @auto_ad
    end

    def set_login
      @user_login = Twitch::User.find(params[:id]).login
    end
  end
end
