module Attachments
  class HostedImagesController < Attachments::BaseController

    def index
      @hosted_image = HostedImage.new
      authorize @hosted_image
    end

    def create
      @hosted_image = HostedImage.new hosted_image_params
      authorize @hosted_image

      if @hosted_image.save
        flash.now[:success] = "Please upload your image. The image will appear under #{@hosted_image.cdn_url}"
        render :update

        track_action! trackable_request
          .assemble_an
          .admin_panel_hosted_image_create(
            filename: params[:attachments_hosted_image][:filename]
          )

      else
        flash.now[:error] = @hosted_image.errors.full_messages.to_sentence
        render :index
      end
    end

    protected

    def hosted_image_params
      params.require(:attachments_hosted_image).permit(:filename)
    end

  end
end
