module BeefCake
  class AttachedPermissionsController < ApplicationController
    before_action :set_attached_permission

    def edit
    end

    def update
      @attached_permission.update_scope(
        params
          .require(:beef_cake_attached_permission)
          .permit(payout_entity_scope: [])[:payout_entity_scope]
          .reject(&:empty?)
      )

      flash[:success] = "Success"
      redirect_to @attached_permission.role
    end

    def destroy
      @attached_permission.delete
      flash[:success] = "Deleted #{@attached_permission.permission.name} from #{@attached_permission.role.name}"
      redirect_to @attached_permission.role
    end

    protected

    def set_attached_permission
      ap_params = params.permit(:role_id, :id)
      @all_channel_payout_scopes = AttachedPermission.all_channel_payout_scopes
      @attached_permission = AttachedPermission.find(
        role_id: ap_params[:role_id],
        attached_permission_id: ap_params[:id]
      )

      authorize @attached_permission
    end
  end
end
