module Notification
  extend ActiveSupport::Concern

  NOTICES = {
    new_home: {
      content: <<~NOTICE,
        <span id="new_home">
          <strong>
            Admin Panel has a new home!
          </strong>
          <a href="https://admin-panel.xarth.tv">https://admin-panel.xarth.tv</a> <br>
          Please <strong> update your bookmarks and custom search engines </strong> to use our new domain.
        </span>
      NOTICE
      type: :info
    }
  }

  def bake_session_notifications(user: nil) # rubocop:disable Lint/UnusedMethodArgument
    notices = [:new_home]
    cookies.encrypted[:session_notice] = notices
  end
end
