module Redirection
  extend ActiveSupport::Concern

  protected

  def back_path
    params[:return_to].presence || request.fullpath
  end

  def store_location
    # ajax posts should not override the session location store
    return if request.xhr? && request.method_symbol != :get

    session[:return_to] = back_path
  end

  def redirect_back_or_default(path = nil)
    path = session.delete(:return_to).presence || path || root_path

    redirect_to path
  end
end
