module ContentTag
  class ChannelTagsController < ContentTag::BaseController
    before_action :set_channel_tag, only: [:show, :edit, :update, :destroy, :delete_channel_tag, :add_channel_tag]

    def index
      authorize ChannelTag

      unless params[:channel_tag].blank?
        @channel_tag = ChannelTag.find(params[:channel_tag][:channel_id])

        return redirect_to content_tag_channel_tag_path(@channel_tag) if @channel_tag.persisted?

        flash.now[:error] = @channel_tag.errors.full_messages.to_sentence
      end
    end

    def show
    end

    def delete_channel_tag
      if @channel_tag.delete_channel_tag(params["tag_id"])
        flash[:success] = "Success"
      else
        flash[:danger] = "ERROR " + @channel_tag.errors.full_messages.to_sentence
      end
      redirect_back
    end

    def add_channel_tag
      @channel_tag.ldap_login = current_user.ldap_login
      if @channel_tag.add_channel_tag(params["content_tag_channel_tag"]["tag_id"])
        flash[:success] = "Success"
      else
        flash[:danger] = "ERROR " + @channel_tag.errors.full_messages.to_sentence
      end
      redirect_back
    end

    protected

    def set_channel_tag
      @channel_tag = ChannelTag.find(params[:id])
      authorize @channel_tag
    end

    def channel_tag_params
      params.require(:content_tag_channel_tag).permit(:channel_id, :channel_name, :tag_name, :tag_id)
    end
  end
end
