module Dmca
  class TakedownsController < Dmca::BaseController
    def takedowns_issued
      authorize Takedown

      @title = "Takedowns Issued"

      @takedowns = []
      begin
        if params[:takedown].present?
          set_params!
          @takedowns = Takedown.find_issued(@user_id, @window_start, @window_end)
        else
          today = Time.now

          @window_start = (today - 7.days).strftime("%F %T")
          @window_end = today.strftime("%F %T")
        end
      rescue StandardError => e
        flash.now[:danger] = e
      end
    end

    def takedowns_received
      authorize Takedown

      @title = "Takedowns Received"

      @takedowns = []
      begin
        if params[:takedown].present?
          set_params!
          @takedowns = Takedown.find_received(@user_id, @window_start, @window_end)
        else
          today = Time.now

          @window_start = (today - 7.days).strftime("%F %T")
          @window_end = today.strftime("%F %T")
        end
      rescue StandardError => e
        flash.now[:danger] = e
      end
    end

    private

    def set_params!
      @user_id = params[:takedown][:user_id]
      @window_start = params[:takedown][:window_start]
      @window_end = params[:takedown][:window_end]
    end
  end
end
