module Drops
  class UsersController < Drops::BaseController
    before_action :set_user, only: [:index]

    def index
      authorize User

      if @user.present? and @user.errors.present?
        flash[:error] = @user.errors.full_messages.to_sentence
      end

      @developers = Developer.scoped
      @developers = @developers.all
    end

    protected

    def set_user
      case params[:id_type]
      when "login"
        @user = User.find_by_twitch_login(params[:service_id], params[:id])
      when "twitch_user_id"
        @user = User.find(params[:service_id], params[:id])
      when "service_user_id"
        @user = User.find_by_service_user_id(params[:service_id], params[:id])
      else
        @user = User.find params[:service_id], params[:twitch_user_id] if params.has_key? :twitch_user_id
      end

      authorize @user if @user.present?
    end
  end
end
