module Games
  class AddAliasesController < Games::BaseController
    before_action :set_add_alias, only: [:show, :edit, :update, :destroy]

    def index
      @add_alias = AddAlias.new
      authorize @add_alias
    end

    def create
      @add_alias = AddAlias.new add_alias_params
      authorize @add_alias

      if @add_alias.save
        flash[:success] = "Success"
        redirect_to games_add_aliases_path
      else
        flash.now[:danger] = @add_alias.errors.full_messages.to_sentence
        render :index
      end
    end

    protected

    def set_add_alias
      @add_alias = AddAlias.find params[:id]
      authorize @add_alias
    end

    def add_alias_params
      params.require(:games_add_alias).permit(:name, :alias)
    end
  end
end
