module Games
  class AddCategoriesController < Games::BaseController
    def index
      @add_category = AddCategory.new
      authorize AddCategory
    end

    def create
      @add_category = AddCategory.new add_categories_params
      authorize AddCategory

      begin
        @add_category.save
        flash[:success] = "Success"
        redirect_to games_add_categories_path
      rescue StandardError => e
        flash.now[:danger] = "Failed to add IGDB Category: #{e.message}"
        render :index
      end
    end

    protected

    def add_categories_params
      params.require(:games_add_category).permit(:igdb_id)
    end

  end
end

