module Games
  class AddCategoryTagsController < Games::BaseController
    before_action :set_add_category_tag, only: [:show, :edit, :update, :destroy]

    def index
      @add_category_tag = AddCategoryTag.new
      authorize AddCategoryTag
    end

    def create
      @add_category_tag = AddCategoryTag.new add_category_tag_params
      authorize @add_category_tag

      @add_category_tag.ldap_login = current_user.ldap_login
      if @add_category_tag.save
        flash[:success] = "Success"
        redirect_to games_add_category_tags_path
      else
        flash.now[:danger] = @add_category_tag.errors.full_messages.to_sentence
        render :index
      end
    end

    protected

    def add_category_tag_params
      params.require(:games_add_category_tag).permit(:game_id, :game_name, :tag_id, :tag_name)
    end
  end
end
