module Games
  class AddGameBannersController < Games::BaseController
    before_action :set_add_game_banner, only: [:show, :update]

    def index
      authorize AddGameBanner

      if params[:name].present?
        @add_game_banner = AddGameBanner.find(params[:name])
        return redirect_to(games_add_game_banner_path(@add_game_banner)) if @add_game_banner.persisted?

        flash.now[:error] = @add_game_banner.errors.full_messages.to_sentence
      end
    end

    def show
    end

    def update
      @add_game_banner.attributes = add_game_banner_params
      @add_game_banner.image = params[:games_add_game_banner][:image]
      if !@add_game_banner.save
        flash.now[:error] = @add_game_banner.errors.full_messages.to_sentence
        render :show
      else
        flash[:success] = "Successfully updated banner for #{@add_game_banner.name}."
        redirect_to @add_game_banner
      end
    end

    protected

    def set_add_game_banner
      @add_game_banner = AddGameBanner.find params[:id]
      unless @add_game_banner.persisted?
        flash[:error] = @add_game_banner.errors.full_messages.to_sentence
        redirect_to games_add_game_banners_path
      end
      authorize @add_game_banner
    end

    def add_game_banner_params
      return {} if params[:games_add_game_banner].blank?
      params.require(:games_add_game_banner).permit(:name, :image, :banner_image_url)
    end
  end
end
