module Games
  class AddLocalizationsController < Games::BaseController
    before_action :set_add_localization, only: [:show, :edit, :update, :destroy]

    def index
      @add_localization = AddLocalization.new
      authorize @add_localization
    end

    def create
      @add_localization = AddLocalization.new add_localization_params
      authorize @add_localization

      if @add_localization.save
        flash[:success] = "Success"
        redirect_to games_add_localizations_path
      else
        flash.now[:danger] = @add_localization.errors.full_messages.to_sentence
        render :index
      end
    end

    protected

    def set_add_localization
      @add_localization = AddLocalization.find params[:id]
      authorize @add_localization
    end

    def add_localization_params
      params.require(:games_add_localization).permit(:name, :localization, :language)
    end
  end
end
