module Games
  class AddNonGiantbombGamesController < Games::BaseController
    before_action :set_add_non_giantbomb_game, only: [:show, :edit, :update, :destroy]

    def index
      @add_non_giantbomb_game = AddNonGiantbombGame.new
      authorize @add_non_giantbomb_game
    end

    def create
      @add_non_giantbomb_game = AddNonGiantbombGame.new add_non_giantbomb_game_params
      authorize @add_non_giantbomb_game

      if @add_non_giantbomb_game.save
        flash[:success] = "Success"
        redirect_to games_add_non_giantbomb_games_path
      else
        flash.now[:danger] = @add_non_giantbomb_game.errors.full_messages.to_sentence
        render :index
      end
    end

    protected

    def set_add_non_giantbomb_game
      @add_non_giantbomb_game = AddNonGiantbombGame.find params[:name]
      authorize @add_non_giantbomb_game
    end

    def add_non_giantbomb_game_params
      params.require(:games_add_non_giantbomb_game).permit(:name)
    end
  end
end
