module GiftCards
  class RedemptionController < GiftCards::BaseController

    def index
      authorize TwitchZuko::RedemptionsHistory

      if params[:user_login].present? || params[:serial_number].present?
        begin
          if params[:user_login].present?
            @twitch_user = Twitch::User.find_by_login(params[:user_login])
          end
        rescue StandardError => e
          flash[:error] = "Failed to fetch user information #{e.message}"
        end

        # Passing empty user_id when the filter doesn't use login info
        user_id = if @twitch_user.present?
                    @twitch_user.id.to_s
                  else
                    ""
                  end
        begin
          @redemptions_history = TwitchZuko::RedemptionsHistory.call(
            user_id,
            params[:serial_number],
            params[:start_date],
            params[:end_date]
          )
        rescue StandardError => e
          flash[:error] = "Failed to fetch balance information #{e.message}"
        end
      end
    end

  end
end
