module Graffiti
  class CreateTagsController < Graffiti::BaseController
    def index
      @create_tag = CreateTag.new
      authorize @create_tag
    end

    def create
      @create_tag = CreateTag.new create_tag_params
      authorize @create_tag

      @create_tag.ldap_login = current_user.ldap_login

      if @create_tag.save
        flash[:success] = "Success"
        redirect_to graffiti_create_tags_path
      else
        flash.now[:danger] = @create_tag.errors.full_messages.to_sentence
        render :index
      end
    end

    protected

    def create_tag_params
      params.require(:graffiti_create_tag).permit(:name, :localize, :tag_scope, :instruction, :description, :internal, :restricted, :persistent)
    end
  end
end
