module Graffiti
  class EditTagsController < Graffiti::BaseController
    before_action :set_edit_tag, only: [:show, :edit, :update, :destroy]

    def index
      authorize EditTag

      unless params[:edit_tag].blank?
        @edit_tag = EditTag.find(params[:edit_tag][:id])
        return redirect_to graffiti_edit_tag_path(@edit_tag) if @edit_tag.persisted?

        flash.now[:error] = @edit_tag.errors.full_messages.to_sentence
      end
    end

    def update
      @edit_tag.attributes = edit_tag_params

      @edit_tag.ldap_login = current_user.ldap_login
      if @edit_tag.save
        flash[:success] = "Success"
        redirect_to graffiti_edit_tag_path(@edit_tag.attributes["id"])
      else
        flash.now[:danger] = @edit_tag.errors.full_messages.to_sentence
        render :edit
      end
    end

    protected

    def set_edit_tag
      @edit_tag = EditTag.find params[:id]
      authorize @edit_tag
    end

    def edit_tag_params
      params.require(:graffiti_edit_tag).permit(:id, :name, :state, :scope, :internal, :localize, *LOCALES, *DESCRIPTION_LOCALES, :restricted, :persistent)
    end
  end
end
