class HealthController < ActionController::Base
  def status
    beefcake_status = check_beefcake
    s2s_status = check_s2s

    if beefcake_status && s2s_status
      render json: {
          beefcake: beefcake_status,
          s2s: s2s_status,
      }, status: 200
    else
      render json: {
          beefcake: beefcake_status,
          s2s: s2s_status,
      }, status: 500
    end
  end

  protected

  def check_beefcake
    BeefCake::Health.status
  end

  def check_s2s
    Service::S2S.instance.client.healthy?
  end
end
