module History
  class BaseController < ApplicationController
    def changeset(resource)
      resource.attributes.except(:user_id, :requester, :location, :status, :deletions_time).map do |key, value_hash|
        ChangeSet.new(
          attribute: key,
          old_value: nil,
          new_value: value_hash
        )
      end
    end
  end

  TrackedEvent::Scaffold.class_eval do
    # rubocop:disable ParameterLists, TrailingWhitespace
    #
    # @param [String] created_after_utc the search filter's UTC start date
    # @param [String] created_before_utc the search filter's UTC end date
    # @param [String] audit_user_type the user type,  
    #        e.g.,    "ldap_user", "twitch_user"
    # @param [String] user_id the ID of the user, either an ldap ID, or a twitch user id
    # @param [String] audit_action an audit action,  
    #        e.g.,    "login_user", "email_changed"
    # @param [String] audit_resource_type the resourse type,  
    #        e.g.,    "ldap_user", "ticket_product"
    # @param [String] audit_resource_id the resource ID, similar to user_id
    # @param [String] audit_attribute the attribute an action has altered,  
    #        e.g.,    "email"
    # @param [String] audit_old_value the old value in a change-set
    # @param [String] audit_new_value the new value in a change-set
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_audits_search(
      created_after_utc:,
      created_before_utc:,
      audit_user_type:,
      user_id:,
      audit_action:,
      audit_resource_type:,
      audit_resource_id:,
      audit_attribute:,
      audit_old_value:,
      audit_new_value:
    )
      build(context: binding)
    end
    # rubocop:enable ParameterLists, TrailingWhitespace
  end
end
