module Payments
  class BaseController < ApplicationController
  end

  TrackedEvent::Scaffold.class_eval do
    # rubocop:disable ParameterLists, TrailingWhitespace

    #
    # @param [String] purchaser_login the twitch login of the purchaser
    # @param [String] recipient_login the twitch login of the user receiving the benefit
    # @param [String] ext_subscription_id the ID of a subscription in the payment provider's system
    # @param [String] product_short_name the product's short_name,  
    #        e.g.,    "twitchsupport", "twitchsupport_3000"
    # @param [String] product_owner_login the twitch login of the user that owns the product
    # @param [String] product_type the product type,  
    #        e.g.,    "Bits", "Channel Sub", "Gift Sub", "Sub Token"
    # @param [String] purchase_platform the platform the purchase was made on,  
    #        i.e.,    "Web", "Android", "iOS"
    # @param [String] payment_provider the payment provider used for the purchase,  
    #        i.e.,    "Recurly", "Xsolla", "Zuora", "Google IAB", "Apple IAP", "Sub Token"
    # @param [String] purchase_order_state the purchase order's success state,  
    #        i.e.,    "Success", "Failed"
    # @param [String] created_after_utc the search filter's UTC start date
    # @param [String] created_before_utc the search filter's UTC end date
    # @param [String] ext_transaction_id the ID of a transaction in the payment provider's system
    # @param [String] purchase_order_id the ID of a Purchase Order in Twitch's system
    # @param [String] origin_id the object ID of the Purchase Order
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_purchase_orders_search(
      purchaser_login:,
      recipient_login:,
      ext_subscription_id:,
      product_short_name:,
      product_owner_login:,
      product_type:,
      purchase_platform:,
      payment_provider:,
      purchase_order_state:,
      created_after_utc:,
      created_before_utc:,
      ext_transaction_id:,
      purchase_order_id:,
      origin_id:
    )
      build(context: binding)
    end

    #
    # @param [String] purchaser_login the twitch login of the purchaser
    # @param [String] purchaser_id the twitch user_id of the purchaser
    # @param [String] created_on_utc the date to use for the search filter
    # @param [String] refund_reason the reason for using the mass-refund tool
    # @param [Boolean] include_channel_subs whether Channel Subscriptions are included in the set
    # @param [Boolean] include_gift_subs whether Gift Subscriptions are included in the set
    # @param [Boolean] include_bits whether Bits are included in the set
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_purchase_mass_refund_create(
      purchaser_login: nil,
      purchaser_id:,
      created_on_utc:,
      refund_reason:,
      include_channel_subs:,
      include_gift_subs:,
      include_bits:
    )
      build(context: binding)
    end

    #
    # @param [String] purchaser_login the twitch login of the purchaser
    # @param [String] purchaser_id the twitch user_id of the purchaser
    # @param [String] created_on_utc the date to use for the search filter
    # @param [String] refund_reason the reason for using the mass-refund tool
    # @param [Boolean] include_channel_subs whether Channel Subscriptions are included in the set
    # @param [Boolean] include_gift_subs whether Gift Subscriptions are included in the set
    # @param [Boolean] include_bits whether Bits are included in the set
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_purchase_mass_refund_search(
      purchaser_login:,
      purchaser_id:,
      created_on_utc:,
      refund_reason:,
      include_channel_subs:,
      include_gift_subs:,
      include_bits:
    )
      build(context: binding)
    end

    #
    # @param [String] purchaser_login the twitch login of the purchaser
    # @param [String] purchaser_name the legal name of the purchaser (if available)
    # @param [String] product_short_name the product's short_name,  
    #        e.g.,    "twitchsupport", "twitchsupport_3000"
    # @param [String] purchaser_email the email address of the purchasing user
    # @param [String] purchase_profile_state the activity state of the purchase profile,  
    #        i.e.,    "active", "cancelled", "inactive", "migrated_v2"
    # @param [String] payment_provider the payment provider used for the purchase,  
    #        i.e.,    "recurly", "xsolla_v3", "zuora", "paypal", "paypal_rt", "free_coupons", "samus", "admin", "test"
    # @param [String] ext_subscription_id the ID of a subscription in the payment provider's system
    # @param [String] ticket_owner_login the "Owner ID" of the actual access Ticket
    # @param [String] created_after_utc the search filter's UTC start date
    # @param [String] created_before_utc the search filter's UTC end date
    # @param [String] product_owner_login the twitch login of the user that owns the product
    # @param [String] ext_transaction_id the ID of a transaction in the payment provider's system
    #
    # @return (see TrackedEvent::Scaffold#build)
    #
    # @macro eventer
    def admin_panel_purchase_profiles_search(
      purchaser_login:,
      purchaser_name:,
      product_short_name:,
      purchaser_email:,
      purchase_profile_state:,
      payment_provider:,
      ext_subscription_id:,
      ticket_owner_login:,
      created_after_utc:,
      created_before_utc:,
      product_owner_login:,
      ext_transaction_id:
    )
      build(context: binding)
    end
    # rubocop:enable ParameterLists, TrailingWhitespace
  end
end
