module Payments
  class XsollaPlansController < Payments::BaseController
    def index
      authorize XsollaPlan
      @xsolla_plans = XsollaPlan.load_plans
    end

    def new
      @xsolla_plan = XsollaPlan.new
      authorize @xsolla_plan
    end

    def create
      @xsolla_plan = XsollaPlan.new xsolla_plan_params
      authorize @xsolla_plan

      if @xsolla_plan.save
        flash[:success] = "Success"
        redirect_to payments_xsolla_plans_path
      else
        flash.now[:danger] = @xsolla_plan.errors.full_messages.to_sentence
        render :new
      end
    end

    def xsolla_plan_params
      params.require(:payments_xsolla_plan).permit(:id, :group_id, :plan_id, :price, :month_interval)
    end
  end
end
