module PayoutEntities
  class BulkInvitationsController < PayoutEntities::BaseController
    def index
      @bulk_invitation = PayoutEntities::BulkInvitation.new
      authorize @bulk_invitation
    end

    def create
      @bulk_invitation = PayoutEntities::BulkInvitation.new invitation_params
      authorize @bulk_invitation

      options = {ldap_login: current_user.ldap_login}
      @bulk_invitation.save(options)

      unless @bulk_invitation.warnings.empty?
        flash[:warning] = @bulk_invitation.warnings.join("<br/>").html_safe
      end
      flash[:success] = @bulk_invitation.successes.join("<br/>").html_safe
      flash[:error] = @bulk_invitation.errors.full_messages.join("<br/>").html_safe

      redirect_back
    end

    protected

    def invitation_params
      params.require(:payout_entities_bulk_invitation)
    end
  end
end
