require 'aws-sdk-lambda'
module RevenueReporting
  class FraudReportsController < RevenueReporting::BaseController

    def index
      authorize FraudReport
      # form initially loads
      return if params[:fraud_reports].blank?
      # do not invoke lambda if form was submitted without a report_id
      return if params[:fraud_reports][:report_id].to_s.blank?
      # invoke a lambda
      @fraud_report = FraudReport.new
      authorize @fraud_report
      if @fraud_report.invoke_lambda(params[:fraud_reports][:report_id].to_s, "fraud_report")
        flash[:success] = @fraud_report.success_message.html_safe
      else
        flash[:error] = @fraud_report.error_message
      end
      redirect_to revenue_reporting_fraud_reports_path
    end
  end
end
